# 🕐💕 ربات تلگرام ساعت‌های جفت

ربات تلگرام خلاقانه که در ساعت‌های جفت پیام‌های عاشقانه می‌فرسته!

---

## 🚀 نصب سریع (3 مرحله!)

### 1️⃣ آپلود فایل‌ها
همه فایل‌ها رو در پوشه `timebot` روی سرور آپلود کن

### 2️⃣ باز کردن صفحه نصب
```
https://amirshasti.ir/timebot/setup.php
```

### 3️⃣ تنظیم Cron Job
بعد از نصب، cron رو طبق راهنما تنظیم کن

**تموم! 🎉**

---

## 📋 اطلاعات تنظیم شده

- ✅ **توکن ربات:** تنظیم شده
- ✅ **دیتابیس:** amirshasti_botdb  
- ✅ **Webhook:** https://amirshasti.ir/timebot/bot.php
- ⏰ **Cron Job:** نیاز به تنظیم دستی در cPanel

---

## ⏰ ساعت‌های جفت

```
00:00 | 01:01 | 02:02 | 03:03 | 04:04 | 05:05
10:10 | 11:11 | 12:12 | 13:13 | 14:14 | 15:15  
20:20 | 21:21 | 22:22 | 23:23
```

هر ساعت 3 پیام خلاقانه مختلف داره که تصادفی انتخاب میشه! 💝

---

## 🎯 دستورات ربات

- `/start` - شروع ربات
- `/help` - راهنما
- `/status` - وضعیت
- `/stop` - توقف پیام‌ها

---

## 🔧 مشکل داری؟

### Cron کار نمی‌کنه؟
```bash
# تست دستی:
php /home/amirshasti/public_html/timebot/cron.php

# یا از طریق وب:
https://amirshasti.ir/timebot/cron.php
```

### Webhook کار نمی‌کنه؟
```bash
# چک کردن:
https://api.telegram.org/bot8169026930:AAENUxTOiL9hNACSOJMrZfXZ5ZwYLjWjP0c/getWebhookInfo
```

### نیاز به راهنمای کامل؟
فایل‌های کمکی:
- `CRON-SETUP.txt` - راهنمای تنظیم cron
- `test.php` - تست ربات
- `auto-cron.php` - کمک برای تنظیم cron

---

## 📁 فایل‌های مهم

| فایل | توضیح |
|------|-------|
| `config.php` | تنظیمات (تنظیم شده ✅) |
| `bot.php` | مدیریت webhook |
| `cron.php` | ارسال پیام‌های زمان‌بندی شده |
| `database.php` | مدیریت دیتابیس |
| `messages.php` | 48+ پیام عاشقانه |
| `setup.php` | نصب خودکار |

---

## 🎨 ویژگی‌ها

- ✅ 16 ساعت جفت
- ✅ 48+ پیام خلاقانه
- ✅ شخصی‌سازی با نام
- ✅ دکمه‌های تعاملی
- ✅ آمار کاربران
- ✅ فعال/غیرفعال کردن
- ✅ لاگ کامل

---

## 💡 نکات امنیتی

1. ✅ فایل `setup.php` رو بعد از نصب حذف کن
2. ✅ فایل `config.php` محافظت شده با .htaccess
3. ✅ رمز دیتابیس قوی هست

---

## 📞 پشتیبانی

اگه مشکلی داشتی:
1. فایل لاگ‌ها رو چک کن: `error.log` و `cron.log`
2. `test.php` رو اجرا کن
3. webhook رو با getWebhookInfo چک کن

---

**ساخته شده با ❤️ برای امیرحسین شاستی**

موفق باشی! 🚀✨

## ✨ ویژگی‌ها

- 📱 پشتیبانی کامل از API تلگرام
- 🕐 ارسال خودکار پیام در 16 ساعت جفت مختلف
- 💕 بیش از 48 پیام عاشقانه و خلاقانه
- 🎯 شخصی‌سازی پیام‌ها با نام کاربر
- 🔔 قابلیت فعال/غیرفعال کردن پیام‌ها
- 📊 آمار دریافت پیام برای هر کاربر
- ⏰ دکمه‌های تعاملی (Inline Keyboard)
- 🗄️ ذخیره‌سازی کاربران در دیتابیس MySQL
- 📝 لاگ کامل فعالیت‌ها و خطاها

## 🎯 ساعت‌های جفت

ربات در ساعت‌های زیر پیام ارسال می‌کند:

```
00:00 - نیمه‌شب آرزوها
01:01 - یکی یکی عاشقتم
02:02 - دو قلب یکی
03:03 - سه کلمه جادویی
04:04 - چهارگوش خوش‌شانسی
05:05 - پنج حس عاشقی
10:10 - صد در صد عشق
11:11 - آرزوی عاشقانه (معروف‌ترین!)
12:12 - نیمه روز عشق
13:13 - شانس من توئی
14:14 - چهارده قلب
15:15 - پونزده دقیقه عشق
20:20 - دید کامل
21:21 - بلک جک عشق
22:22 - دو دو تا، چهار تا عشق
23:23 - آخرین ساعت جفت
```

## 📋 پیش‌نیازها

- PHP 7.4 یا بالاتر
- MySQL 5.7 یا بالاتر
- وب‌سرور (Apache/Nginx)
- Cron Job (برای اجرای خودکار)
- حساب تلگرام و دسترسی به BotFather

## 🚀 نصب و راه‌اندازی

### 1. دریافت توکن ربات از BotFather

1. در تلگرام به [@BotFather](https://t.me/botfather) پیام دهید
2. دستور `/newbot` را ارسال کنید
3. نام و username برای ربات انتخاب کنید
4. توکن دریافتی را کپی کنید

### 2. تنظیمات فایل‌ها

فایل `config.php` را باز کرده و تنظیمات زیر را انجام دهید:

```php
// توکن ربات تلگرام
define('BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE');

// مشخصات دیتابیس
define('DB_HOST', 'localhost');
define('DB_NAME', 'timebot_db');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 3. ساخت دیتابیس

```bash
# ورود به MySQL
mysql -u root -p

# ساخت دیتابیس
CREATE DATABASE timebot_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

جدول `users` به صورت خودکار ساخته می‌شود.

### 4. آپلود فایل‌ها

تمام فایل‌ها را در یک پوشه روی سرور خود آپلود کنید:

```
/var/www/html/timebot/
├── config.php
├── bot.php
├── cron.php
├── database.php
├── messages.php
└── README.md
```

### 5. تنظیم Webhook

```bash
# جایگزینی TOKEN و YOUR_DOMAIN
curl -F "url=https://YOUR_DOMAIN.com/timebot/bot.php" \
     https://api.telegram.org/botYOUR_TOKEN/setWebhook
```

مثال:
```bash
curl -F "url=https://example.com/timebot/bot.php" \
     https://api.telegram.org/bot123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11/setWebhook
```

### 6. تنظیم Cron Job

برای ارسال خودکار پیام‌ها، یک Cron Job تنظیم کنید که هر دقیقه اجرا شود:

```bash
# باز کردن ویرایشگر crontab
crontab -e

# اضافه کردن این خط:
* * * * * /usr/bin/php /var/www/html/timebot/cron.php >> /var/www/html/timebot/cron.log 2>&1
```

یا از cPanel:

```
Command: /usr/bin/php /home/username/public_html/timebot/cron.php
Minute: *
Hour: *
Day: *
Month: *
Weekday: *
```

## 🎮 استفاده

### دستورات ربات

- `/start` - شروع و فعال‌سازی ربات
- `/help` - نمایش راهنما
- `/status` - نمایش وضعیت فعلی
- `/stop` - توقف ارسال پیام‌ها

### دکمه‌های تعاملی

- 💕 **دریافت پیام الان** - دریافت فوری پیام ساعت فعلی
- 📊 **آمار من** - مشاهده آمار دریافت پیام‌ها
- 🔔 **فعال کردن** - فعال‌سازی ارسال پیام‌ها
- 🔕 **غیرفعال کردن** - توقف ارسال پیام‌ها

## 📁 ساختار فایل‌ها

### config.php
تنظیمات اصلی ربات شامل توکن، دیتابیس و timezone

### bot.php
مدیریت webhook و پردازش پیام‌های دریافتی از کاربران

### cron.php
بررسی ساعت‌های جفت و ارسال پیام به کاربران فعال

### database.php
مدیریت دیتابیس و توابع CRUD برای کاربران

### messages.php
بانک اطلاعاتی پیام‌های عاشقانه برای هر ساعت (48+ پیام)

## 🔧 تنظیمات پیشرفته

### تغییر تایم‌زون

در فایل `config.php`:

```php
define('TIMEZONE', 'Asia/Tehran'); // برای ایران
```

سایر تایم‌زون‌ها:
- `Asia/Dubai` - امارات
- `Asia/Riyadh` - عربستان
- `Europe/Istanbul` - ترکیه

### غیرفعال کردن دیباگ مود

در محیط production:

```php
define('DEBUG_MODE', false);
```

### اضافه کردن پیام‌های جدید

در فایل `messages.php`، آرایه `$messages` را ویرایش کنید:

```php
'01:01' => [
    "پیام عاشقانه جدید شما...",
    "پیام دوم...",
    "پیام سوم..."
],
```

## 📊 مانیتورینگ

### مشاهده لاگ‌ها

```bash
# لاگ فعالیت‌ها
tail -f /var/www/html/timebot/activity.log

# لاگ خطاها
tail -f /var/www/html/timebot/error.log

# لاگ cron
tail -f /var/www/html/timebot/cron.log
```

### بررسی وضعیت webhook

```bash
curl https://api.telegram.org/botYOUR_TOKEN/getWebhookInfo
```

## 🐛 عیب‌یابی

### ربات پاسخ نمی‌دهد

1. بررسی webhook:
```bash
curl https://api.telegram.org/botYOUR_TOKEN/getWebhookInfo
```

2. بررسی لاگ خطاها:
```bash
tail -50 error.log
```

3. بررسی دسترسی‌های فایل:
```bash
chmod 755 *.php
chmod 666 *.log
```

### پیام‌ها ارسال نمی‌شوند

1. بررسی cron job:
```bash
crontab -l
```

2. اجرای دستی cron:
```bash
php cron.php
```

3. بررسی دیتابیس:
```sql
SELECT * FROM users WHERE active = 1;
```

### مشکل دیتابیس

```bash
# بررسی اتصال
mysql -u root -p

# بررسی جدول
USE timebot_db;
SHOW TABLES;
DESCRIBE users;
```

## 🎨 سفارشی‌سازی

### تغییر استایل پیام‌ها

پیام‌ها از HTML formatting استفاده می‌کنند:

- `<b>متن</b>` - Bold
- `<i>متن</i>` - Italic
- `<code>متن</code>` - Monospace
- `<a href="url">متن</a>` - لینک

### اضافه کردن دکمه‌های جدید

در فایل `bot.php`، بخش `inline_keyboard` را ویرایش کنید:

```php
$keyboard = [
    'inline_keyboard' => [
        [
            ['text' => '🆕 دکمه جدید', 'callback_data' => 'new_action']
        ]
    ]
];
```

## 📈 آمار و گزارش

### آمار کلی

```sql
-- تعداد کل کاربران
SELECT COUNT(*) FROM users;

-- تعداد کاربران فعال
SELECT COUNT(*) FROM users WHERE active = 1;

-- میانگین پیام‌های دریافتی
SELECT AVG(message_count) FROM users;

-- کاربران پرپیام
SELECT first_name, message_count FROM users ORDER BY message_count DESC LIMIT 10;
```

## 🔐 امنیت

- توکن ربات را هرگز در گیت commit نکنید
- از HTTPS برای webhook استفاده کنید
- به صورت دوره‌ای پسخ‌گیری از دیتابیس بگیرید
- دسترسی فایل‌های لاگ را محدود کنید

## 🤝 مشارکت

اگر می‌خواهید به بهبود این ربات کمک کنید:

1. پیام‌های عاشقانه جدید اضافه کنید
2. باگ‌های احتمالی را گزارش دهید
3. ویژگی‌های جدید پیشنهاد دهید

## 📝 لایسنس

این پروژه رایگان و متن‌باز است. می‌توانید آزادانه استفاده، تغییر و توزیع کنید.

## 💡 ایده‌های توسعه

- [ ] افزودن قابلیت انتخاب زبان
- [ ] اضافه کردن تصاویر به پیام‌ها
- [ ] ارسال استیکر همراه پیام
- [ ] پیام‌های ویژه برای مناسبت‌های خاص
- [ ] پنل مدیریت وب
- [ ] آمار پیشرفته با نمودار
- [ ] قابلیت ارسال پیام‌های صوتی

## 📞 پشتیبانی

در صورت بروز مشکل:

1. ابتدا بخش عیب‌یابی را بررسی کنید
2. لاگ‌های خطا را چک کنید
3. مستندات API تلگرام را مطالعه کنید

---

## 🎉 از استفاده لذت ببرید!

این ربات با ❤️ ساخته شده تا لحظات خاص را برای کاربران شما به یادماندنی کند! 🕐💕

**نکته:** هر ساعت جفت معنی و مفهوم خاص خودش رو داره و پیام‌ها طوری طراحی شدن که همون احساس رو منتقل کنن. مثلا 11:11 برای آرزوکردن معروفه، 00:00 شروع روز جدیده، 12:12 اوج روزه و...

موفق باشید! 🚀✨
