<?php
/**
 * تنظیم خودکار Cron Job از طریق وب
 * این فایل سعی می‌کند cron job را به صورت خودکار اضافه کند
 */

$output = [];
$cron_command = "* * * * * /usr/bin/php " . __DIR__ . "/cron.php >> " . __DIR__ . "/cron.log 2>&1";

// روش 1: تلاش برای افزودن از طریق crontab (نیاز به دسترسی shell)
$output[] = "🔍 تلاش برای تنظیم خودکار Cron Job...";

if (function_exists('shell_exec')) {
    // دریافت crontab فعلی
    $current_crontab = @shell_exec('crontab -l 2>/dev/null');
    
    // بررسی اینکه قبلا اضافه نشده باشد
    if (strpos($current_crontab, 'timebot/cron.php') === false) {
        // اضافه کردن cron job جدید
        $new_crontab = $current_crontab . "\n" . $cron_command . "\n";
        
        // ذخیره در فایل موقت
        $temp_file = tempnam(sys_get_temp_dir(), 'crontab');
        file_put_contents($temp_file, $new_crontab);
        
        // اعمال crontab جدید
        $result = @shell_exec("crontab $temp_file 2>&1");
        @unlink($temp_file);
        
        if (strpos($result, 'error') === false) {
            $output[] = "✅ Cron Job با موفقیت اضافه شد!";
            $success = true;
        } else {
            $output[] = "⚠️  نتوانستیم به صورت خودکار cron اضافه کنیم";
            $output[] = "💡 باید دستی از cPanel اضافه کنید";
            $success = false;
        }
    } else {
        $output[] = "✅ Cron Job قبلا اضافه شده است";
        $success = true;
    }
} else {
    $output[] = "⚠️  تابع shell_exec غیرفعال است";
    $output[] = "💡 باید دستی از cPanel اضافه کنید";
    $success = false;
}

// روش 2: ساخت فایل راهنما برای تنظیم دستی
if (!$success) {
    $output[] = "\n📝 راهنمای تنظیم دستی:";
    $output[] = "1. وارد cPanel شوید";
    $output[] = "2. به بخش Cron Jobs بروید";  
    $output[] = "3. دستور زیر را اضافه کنید:";
    $output[] = "   " . $cron_command;
}

// ساخت اسکریپت wrapper برای اجرای آسان‌تر
$wrapper_script = "#!/bin/bash\n";
$wrapper_script .= "# Cron Job Wrapper برای ربات تلگرام\n";
$wrapper_script .= "# این فایل را هر دقیقه اجرا کنید\n\n";
$wrapper_script .= "cd " . __DIR__ . "\n";
$wrapper_script .= "/usr/bin/php cron.php >> cron.log 2>&1\n";

file_put_contents('run-cron.sh', $wrapper_script);
chmod('run-cron.sh', 0755);
$output[] = "\n✅ فایل run-cron.sh ساخته شد";

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تنظیم Cron Job</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
        }
        h1 { color: #667eea; text-align: center; margin-bottom: 30px; }
        .output {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            font-family: 'Courier New', monospace;
            white-space: pre-wrap;
            line-height: 1.8;
        }
        .code-box {
            background: #2d3748;
            color: #48bb78;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            margin: 20px 0;
            overflow-x: auto;
            direction: ltr;
            text-align: left;
        }
        .section {
            background: #e3f2fd;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .steps {
            margin: 20px 0;
        }
        .step {
            background: white;
            padding: 15px;
            margin: 10px 0;
            border-radius: 8px;
            border-right: 4px solid #667eea;
        }
        img {
            max-width: 100%;
            border-radius: 10px;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>⏰ تنظیم Cron Job</h1>
        
        <div class="output">
<?php echo implode("\n", $output); ?>
        </div>

        <?php if (!$success): ?>
        <div class="section">
            <h3 style="color: #1976d2; margin-bottom: 15px;">📋 راهنمای تصویری تنظیم در cPanel</h3>
            
            <div class="steps">
                <div class="step">
                    <h4>مرحله 1: ورود به cPanel</h4>
                    <p>به آدرس <code>amirshasti.ir/cpanel</code> بروید و وارد شوید</p>
                </div>

                <div class="step">
                    <h4>مرحله 2: پیدا کردن Cron Jobs</h4>
                    <p>در قسمت "Advanced" گزینه "Cron Jobs" را پیدا کنید</p>
                </div>

                <div class="step">
                    <h4>مرحله 3: افزودن Cron Job جدید</h4>
                    <p>در قسمت "Add New Cron Job":</p>
                    <ul style="margin: 10px 20px;">
                        <li><strong>Common Settings:</strong> Every Minute (* * * * *)</li>
                        <li><strong>Command:</strong> دستور زیر را کپی کنید:</li>
                    </ul>
                    <div class="code-box"><?php echo htmlspecialchars($cron_command); ?></div>
                </div>

                <div class="step">
                    <h4>مرحله 4: ذخیره</h4>
                    <p>روی دکمه "Add New Cron Job" کلیک کنید</p>
                </div>
            </div>
        </div>

        <div class="section" style="background: #fff3cd;">
            <h3 style="color: #856404;">💡 روش جایگزین</h3>
            <p>اگر نمی‌توانید از cPanel استفاده کنید، از یکی از روش‌های زیر استفاده کنید:</p>
            
            <h4 style="margin-top: 15px;">روش 1: استفاده از خدمات Cron رایگان</h4>
            <ul style="margin: 10px 20px; line-height: 2;">
                <li><a href="https://cron-job.org" target="_blank">cron-job.org</a> - رایگان</li>
                <li><a href="https://www.easycron.com" target="_blank">EasyCron</a> - رایگان تا 100 بار در روز</li>
            </ul>
            <p>URL برای فراخوانی:</p>
            <div class="code-box">https://amirshasti.ir/timebot/cron.php</div>

            <h4 style="margin-top: 15px;">روش 2: استفاده از bot-polling.php</h4>
            <p>اگر دسترسی SSH دارید:</p>
            <div class="code-box">nohup php <?php echo __DIR__; ?>/bot-polling.php &</div>
        </div>
        <?php endif; ?>

        <div style="text-align: center; margin-top: 30px;">
            <a href="setup.php" style="display: inline-block; padding: 12px 30px; background: #667eea; color: white; text-decoration: none; border-radius: 10px;">
                🔙 بازگشت به صفحه نصب
            </a>
        </div>
    </div>
</body>
</html>
