<?php
/**
 * ربات تلگرام ساعت‌های جفت 🕐💕
 * این فایل درخواست‌های webhook را دریافت و پردازش می‌کند
 */

require_once 'config.php';
require_once 'database.php';

// دریافت داده‌های ورودی از تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) {
    exit;
}

logActivity("Update received: " . json_encode($update));

// دریافت اطلاعات پیام
$message = isset($update['message']) ? $update['message'] : null;
$chat_id = isset($message['chat']['id']) ? $message['chat']['id'] : null;
$text = isset($message['text']) ? $message['text'] : '';
$first_name = isset($message['from']['first_name']) ? $message['from']['first_name'] : 'کاربر';
$user_id = isset($message['from']['id']) ? $message['from']['id'] : null;

// آیدی ادمین
define('ADMIN_ID', 534254245);

/**
 * ارسال پیام به کاربر
 */
function sendMessage($chat_id, $text, $parse_mode = 'HTML') {
    $url = API_URL . "sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => $parse_mode
    ];
    
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    
    logActivity("Message sent to $chat_id: $text");
    return $result;
}

/**
 * ارسال پیام با دکمه شیشه‌ای
 */
function sendMessageWithButton($chat_id, $text) {
    $url = API_URL . "sendMessage";
    
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '💕 دریافت پیام الان', 'callback_data' => 'get_now'],
                ['text' => '📊 آمار من', 'callback_data' => 'stats']
            ],
            [
                ['text' => '🔕 غیرفعال کردن', 'callback_data' => 'disable'],
                ['text' => '🔔 فعال کردن', 'callback_data' => 'enable']
            ]
        ]
    ];
    
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard)
    ];
    
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    
    return $result;
}

// پردازش callback queries (دکمه‌های شیشه‌ای)
if (isset($update['callback_query'])) {
    $callback_query = $update['callback_query'];
    $callback_data = $callback_query['data'];
    $chat_id = $callback_query['message']['chat']['id'];
    $message_id = $callback_query['message']['message_id'];
    $user_first_name = $callback_query['from']['first_name'] ?? 'کاربر';
    $username = isset($callback_query['from']['username']) ? '@' . $callback_query['from']['username'] : 'ندارد';
    
    // جواب دادن به callback query
    $url = API_URL . "answerCallbackQuery";
    file_get_contents($url . "?callback_query_id=" . $callback_query['id']);
    
    // ارسال ری‌اکشن به ادمین (برای دکمه‌های قلب)
    if (in_array($callback_data, ['like', 'love', 'fire'])) {
        $reactions = [
            'like' => '❤️ لایک',
            'love' => '💝 عشق',
            'fire' => '🔥 آتیش'
        ];
        
        $reactionName = $reactions[$callback_data];
        $adminMessage = "🎯 <b>ری‌اکشن جدید!</b>\n\n";
        $adminMessage .= "👤 <b>کاربر:</b> $user_first_name\n";
        $adminMessage .= "🆔 <b>آیدی:</b> <code>$chat_id</code>\n";
        $adminMessage .= "📱 <b>یوزرنیم:</b> $username\n";
        $adminMessage .= "💫 <b>ری‌اکشن:</b> $reactionName\n";
        $adminMessage .= "⏰ <b>زمان:</b> " . date('Y/m/d H:i:s') . "\n";
        
        // ارسال به ادمین
        sendMessage(534254245, $adminMessage);
        
        // پاسخ به کاربر
        $url = API_URL . "answerCallbackQuery";
        $response = [
            'callback_query_id' => $callback_query['id'],
            'text' => "ممنون! $reactionName شما ثبت شد 😊",
            'show_alert' => false
        ];
        file_get_contents($url . '?' . http_build_query($response));
        exit;
    }
    
    switch ($callback_data) {
        case 'get_now':
            require_once 'messages.php';
            $current_time = date('H:i');
            $message_text = getMessageForTime($current_time);
            sendMessage($chat_id, $message_text);
            break;
            
        case 'stats':
            $stats = getUserStats($chat_id);
            $statsText = "📊 <b>آمار شما:</b>\n\n";
            $statsText .= "🔢 تعداد پیام‌های دریافتی: " . $stats['message_count'] . "\n";
            $statsText .= "📅 عضو از: " . $stats['join_date'] . "\n";
            $statsText .= "✅ وضعیت: " . ($stats['active'] ? 'فعال 🔔' : 'غیرفعال 🔕');
            sendMessage($chat_id, $statsText);
            break;
            
        case 'disable':
            updateUserStatus($chat_id, 0);
            sendMessage($chat_id, "🔕 پیام‌های ساعت‌های جفت برای شما غیرفعال شد.\n\nبرای فعال‌سازی مجدد دستور /start را ارسال کنید.");
            break;
            
        case 'enable':
            updateUserStatus($chat_id, 1);
            sendMessage($chat_id, "🔔 پیام‌های ساعت‌های جفت برای شما فعال شد!\n\nحالا در هر ساعت جفت یک پیام عاشقانه دریافت خواهید کرد 💕");
            break;
    }
    exit;
}

// پردازش دستورات
if ($text && $chat_id) {
    switch ($text) {
        case '/start':
            addUser($chat_id, $first_name);
            
            $welcomeMessage = "💕 <b>سلام $first_name عزیز!</b> 💕\n\n";
            $welcomeMessage .= "به ربات ساعت‌های جفت خوش اومدی! 🕐✨\n\n";
            $welcomeMessage .= "🌟 من هر ساعت جفت (مثل 11:11، 12:12، 01:01 و...) \n";
            $welcomeMessage .= "یک پیام عاشقانه و خاص برات می‌فرستم که معنی همون ساعته! 💌\n\n";
            $welcomeMessage .= "✅ الان فعالی و آماده دریافت پیام‌های عاشقانه هستی!\n\n";
            $welcomeMessage .= "━━━━━━━━━━━━━━━━━━\n";
            $welcomeMessage .= "🕐 ساعت‌های جفت:\n";
            $welcomeMessage .= "00:00 | 01:01 | 02:02 | 03:03\n";
            $welcomeMessage .= "04:04 | 05:05 | 10:10 | 11:11\n";
            $welcomeMessage .= "12:12 | 13:13 | 14:14 | 15:15\n";
            $welcomeMessage .= "20:20 | 21:21 | 22:22 | 23:23\n";
            $welcomeMessage .= "━━━━━━━━━━━━━━━━━━\n\n";
            $welcomeMessage .= "از دکمه‌های زیر می‌تونی استفاده کنی:";
            
            sendMessageWithButton($chat_id, $welcomeMessage);
            break;
            
        case '/help':
            $helpMessage = "📖 <b>راهنمای ربات ساعت‌های جفت</b>\n\n";
            $helpMessage .= "🤖 <b>دستورات:</b>\n";
            $helpMessage .= "/start - شروع و فعال‌سازی ربات\n";
            $helpMessage .= "/help - نمایش راهنما\n";
            $helpMessage .= "/status - وضعیت فعلی\n";
            $helpMessage .= "/stop - توقف پیام‌ها\n\n";
            $helpMessage .= "💡 <b>نکات:</b>\n";
            $helpMessage .= "• پیام‌ها به صورت خودکار در ساعت‌های جفت ارسال می‌شن\n";
            $helpMessage .= "• می‌تونی از دکمه‌ها برای مدیریت استفاده کنی\n";
            $helpMessage .= "• هر پیام معنی خاص همون ساعت رو داره\n\n";
            $helpMessage .= "❤️ ساخته شده با عشق!";
            sendMessage($chat_id, $helpMessage);
            break;
            
        case '/status':
            if ($user_id == ADMIN_ID) {
                // برای ادمین، آمار کامل نشون بده
                $user = getUser($chat_id);
                $totalUsers = getTotalUsersCount();
                $activeUsers = getActiveUsersCount();
                
                $statusMessage = "📊 <b>وضعیت ربات</b>\n\n";
                $statusMessage .= "👤 <b>شما:</b>\n";
                $statusMessage .= "   " . ($user && $user['active'] ? '✅ فعال' : '🔕 غیرفعال') . "\n\n";
                $statusMessage .= "📈 <b>آمار کلی:</b>\n";
                $statusMessage .= "   👥 کل کاربران: $totalUsers\n";
                $statusMessage .= "   ✅ فعال: $activeUsers\n";
                $statusMessage .= "   🔕 غیرفعال: " . ($totalUsers - $activeUsers) . "\n\n";
                $statusMessage .= "⏰ زمان: " . date('H:i:s') . "\n";
                $statusMessage .= "📅 تاریخ: " . date('Y/m/d');
                
                sendMessage($chat_id, $statusMessage);
            } else {
                // برای کاربر عادی
                $user = getUser($chat_id);
                if ($user && $user['active']) {
                    $statusMessage = "✅ <b>وضعیت: فعال</b> 🔔\n\n";
                    $statusMessage .= "شما در حال دریافت پیام‌های ساعت‌های جفت هستید.\n\n";
                    $statusMessage .= "⏰ زمان فعلی: " . date('H:i:s') . "\n";
                    $statusMessage .= "📅 تاریخ: " . date('Y/m/d');
                } else {
                    $statusMessage = "🔕 <b>وضعیت: غیرفعال</b>\n\n";
                    $statusMessage .= "برای فعال‌سازی دستور /start را ارسال کنید.";
                }
                sendMessage($chat_id, $statusMessage);
            }
            break;
            
        case '/stop':
            updateUserStatus($chat_id, 0);
            sendMessage($chat_id, "🔕 پیام‌های ساعت‌های جفت متوقف شد.\n\nبرای فعال‌سازی مجدد /start را بزنید.");
            break;
        
        // 🔐 دستورات پنل ادمین (فقط برای آیدی 534254245)
        case '/admin':
            if ($user_id == ADMIN_ID) {
                $adminMenu = "🔐 <b>پنل مدیریت ربات</b>\n\n";
                $adminMenu .= "به پنل ادمین خوش آمدید!\n\n";
                $adminMenu .= "📊 <b>دستورات ادمین:</b>\n";
                $adminMenu .= "/stats - آمار کامل ربات\n";
                $adminMenu .= "/users - لیست کاربران\n";
                $adminMenu .= "/broadcast - ارسال پیام همگانی\n";
                $adminMenu .= "/logs - مشاهده لاگ‌ها\n\n";
                $adminMenu .= "⚡ فقط شما به این بخش دسترسی دارید!";
                sendMessage($chat_id, $adminMenu);
            }
            break;
            
        case '/stats':
            if ($user_id == ADMIN_ID) {
                $totalUsers = getTotalUsersCount();
                $activeUsers = getActiveUsersCount();
                $inactiveUsers = $totalUsers - $activeUsers;
                
                $statsMessage = "📊 <b>آمار کامل ربات</b>\n\n";
                $statsMessage .= "👥 تعداد کل کاربران: <b>$totalUsers</b>\n";
                $statsMessage .= "✅ کاربران فعال: <b>$activeUsers</b>\n";
                $statsMessage .= "🔕 کاربران غیرفعال: <b>$inactiveUsers</b>\n\n";
                $statsMessage .= "⏰ زمان: " . date('Y/m/d H:i:s') . "\n";
                $statsMessage .= "📈 نرخ فعال‌سازی: " . ($totalUsers > 0 ? round(($activeUsers/$totalUsers)*100, 1) : 0) . "%";
                sendMessage($chat_id, $statsMessage);
            }
            break;
            
        case '/users':
            if ($user_id == ADMIN_ID) {
                $allUsers = getAllUsers();
                
                if (count($allUsers) == 0) {
                    sendMessage($chat_id, "❌ هیچ کاربری یافت نشد!\n\nاحتمالاً هنوز کسی /start نزده.");
                    break;
                }
                
                $usersList = "👥 <b>لیست کاربران (" . count($allUsers) . " نفر)</b>\n\n";
                
                $counter = 1;
                foreach (array_slice($allUsers, 0, 15) as $user) {
                    $status = $user['active'] ? '✅' : '🔕';
                    $usersList .= "$counter. $status <b>" . htmlspecialchars($user['first_name']) . "</b>\n";
                    $usersList .= "   🆔 <code>" . $user['chat_id'] . "</code>\n";
                    $usersList .= "   📊 پیام‌ها: " . $user['message_count'] . " | 📅 " . substr($user['created_at'], 0, 10) . "\n\n";
                    $counter++;
                }
                
                if (count($allUsers) > 15) {
                    $usersList .= "📝 فقط 15 کاربر اول نمایش داده شد.\n";
                    $usersList .= "کل کاربران: " . count($allUsers);
                }
                
                sendMessage($chat_id, $usersList);
            }
            break;
            
        case '/logs':
            if ($user_id == ADMIN_ID) {
                $logFile = __DIR__ . '/activity.log';
                if (file_exists($logFile) && filesize($logFile) > 0) {
                    $logs = file($logFile);
                    $logs = array_slice($logs, -15); // آخرین 15 خط
                    
                    $logsText = "📋 <b>آخرین فعالیت‌ها (15 خط)</b>\n\n";
                    $logsText .= "<pre>";
                    foreach (array_reverse($logs) as $log) {
                        $logsText .= htmlspecialchars(trim($log)) . "\n";
                    }
                    $logsText .= "</pre>";
                    
                    sendMessage($chat_id, $logsText);
                } else {
                    sendMessage($chat_id, "❌ فایل لاگ خالی است یا وجود ندارد!");
                }
            }
            break;
            
        default:
            // اگر پیام با /broadcast شروع شده (برای ادمین)
            if ($user_id == ADMIN_ID && strpos($text, '/broadcast') === 0) {
                // حذف /broadcast و فضای خالی
                $broadcastMessage = trim(substr($text, 10)); // حذف "/broadcast"
                
                if (strlen($broadcastMessage) > 0) {
                    $activeUsersList = getActiveUsers();
                    
                    if (count($activeUsersList) == 0) {
                        sendMessage($chat_id, "❌ هیچ کاربر فعالی یافت نشد!");
                        break;
                    }
                    
                    $successCount = 0;
                    $failCount = 0;
                    
                    foreach ($activeUsersList as $user) {
                        if (sendMessage($user['chat_id'], $broadcastMessage)) {
                            $successCount++;
                        } else {
                            $failCount++;
                        }
                        usleep(100000); // 100ms تاخیر
                    }
                    
                    $result = "📢 <b>گزارش پیام همگانی</b>\n\n";
                    $result .= "✅ ارسال موفق: $successCount\n";
                    $result .= "❌ خطا: $failCount\n";
                    $result .= "📊 کل: " . ($successCount + $failCount);
                    sendMessage($chat_id, $result);
                } else {
                    sendMessage($chat_id, "❌ پیام خالی است!\n\n<b>نحوه استفاده:</b>\n/broadcast متن پیام شما\n\n<b>مثال:</b>\n/broadcast سلام به همه! 💕");
                }
            } else {
                $randomMessage = "🤔 دستور نامعتبر!\n\n";
                $randomMessage .= "برای مشاهده دستورات /help را بزنید.";
                sendMessage($chat_id, $randomMessage);
            }
            break;
    }
}
