<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ربات تلگرام ساعت‌های جفت 🕐💕</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 500px;
            width: 100%;
            padding: 40px;
            text-align: center;
        }
        .emoji {
            font-size: 80px;
            margin-bottom: 20px;
            animation: pulse 2s ease-in-out infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
        h1 {
            color: #667eea;
            font-size: 32px;
            margin-bottom: 10px;
        }
        p {
            color: #666;
            line-height: 1.8;
            margin: 15px 0;
        }
        .btn {
            display: inline-block;
            padding: 15px 40px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            margin: 10px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
        }
        .time-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 10px;
            margin: 30px 0;
        }
        .time-badge {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 10px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 14px;
        }
        .status {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .status-item {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        .status-item:last-child {
            border-bottom: none;
        }
        .badge {
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .badge-success {
            background: #d4edda;
            color: #155724;
        }
        .badge-warning {
            background: #fff3cd;
            color: #856404;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="emoji">🕐💕</div>
        <h1>ربات ساعت‌های جفت</h1>
        <p>پیام‌های عاشقانه در ساعت‌های خاص!</p>

        <div class="status">
            <div class="status-item">
                <span>وضعیت ربات:</span>
                <span class="badge badge-success">✅ فعال</span>
            </div>
            <div class="status-item">
                <span>Webhook:</span>
                <span class="badge badge-success">✅ تنظیم شده</span>
            </div>
            <div class="status-item">
                <span>Cron Job:</span>
                <span class="badge badge-warning">⏳ نیاز به تنظیم</span>
            </div>
        </div>

        <h3 style="color: #667eea; margin: 30px 0 20px;">⏰ ساعت‌های جفت</h3>
        <div class="time-grid">
            <div class="time-badge">00:00</div>
            <div class="time-badge">01:01</div>
            <div class="time-badge">02:02</div>
            <div class="time-badge">03:03</div>
            <div class="time-badge">04:04</div>
            <div class="time-badge">05:05</div>
            <div class="time-badge">10:10</div>
            <div class="time-badge">11:11</div>
            <div class="time-badge">12:12</div>
            <div class="time-badge">13:13</div>
            <div class="time-badge">14:14</div>
            <div class="time-badge">15:15</div>
            <div class="time-badge">20:20</div>
            <div class="time-badge">21:21</div>
            <div class="time-badge">22:22</div>
            <div class="time-badge">23:23</div>
        </div>

        <div style="margin-top: 30px;">
            <a href="install.php" class="btn">🚀 شروع نصب</a>
            <a href="test.php" class="btn">🧪 تست ربات</a>
        </div>

        <div style="margin-top: 30px;">
            <a href="auto-cron.php" style="color: #667eea; text-decoration: none; font-size: 14px;">
                ⏰ تنظیم Cron Job
            </a>
            <span style="color: #ccc; margin: 0 10px;">|</span>
            <a href="README.md" style="color: #667eea; text-decoration: none; font-size: 14px;">
                📖 راهنما
            </a>
        </div>

        <p style="margin-top: 30px; color: #999; font-size: 12px;">
            ساخته شده با ❤️ برای امیرحسین شاستی
        </p>
    </div>
</body>
</html>
